/*
 * EPC_Defines.h
 *
 *  Created on: 06.05.2009
 *      Author: stefan.detter
 */

#ifndef EPC_DEFINES_H_
#define EPC_DEFINES_H_


#include <QMap>
#include <QStringList>
#include <QPair>

//EPC Wordpointer Addresses
/** Definition for EPC wordpointer: Address for CRC value */
#define MEMADR_CRC        0x00
/** Definition for EPC wordpointer: Address for PC value Word position*/
#define MEMADR_PC         0x01
/** Definition for EPC wordpointer: Address for EPC value */
#define MEMADR_EPC        0x02

/** Definition for EPC wordpointer: Address for kill password value */
#define MEMADR_KILLPWD    0x00
/** Definition for EPC wordpointer: Address for access password value */
#define MEMADR_ACCESSPWD  0x02

/** Definition for EPC wordpointer: Address for TID value */
#define MEMADR_TID        0x00


namespace EPCGlobal
{
	typedef enum{
		MEM_RES 	= 0x00,
		MEM_EPC 	= 0x01,
		MEM_TID 	= 0x02,
		MEM_USER 	= 0x03,
	} MEMORY_BANK;

	typedef enum{
		LOCK_MODE_UNLOCK 				= 0x00,
		LOCK_MODE_LOCK 					= 0x01,
		LOCK_MODE_PERMALOCK 			= 0x02,
		LOCK_MODE_LOCK_AND_PERMALOCK	= 0x03
	} LOCK_MODE;

	typedef enum{
		LOCK_MEM_SPACE_KILL_PASSWORD 	= 0x00,
		LOCK_MEM_SPACE_ACCESS_PASSWORD 	= 0x01,
		LOCK_MEM_SPACE_EPC 				= 0x02,
		LOCK_MEM_SPACE_TID 				= 0x03,
		LOCK_MEM_SPACE_USER 			= 0x04,
	} LOCK_MEMORY_SPACE;

	typedef struct {
		QString 	manufacturer;
		QString 	model;
		int 		userMemSize;
		bool 		hasSerialNumber;
		quint64 	serialNumber;
	} TID_Info;
	//Q_DECLARE_METATYPE(TID_Info)



	QString memBankToString( const uint memBank );

    int getTIDInfoSize ( const QByteArray& tid );
	TID_Info getTIDInfo ( const QByteArray& tidData );






	class Loader
	{
	public:
		Loader();

	private:
		static Loader loader;
	};

}

#endif /* EPC_DEFINES_H_ */
